package org.msh.tb.reports2.variables;

import org.msh.reports.keys.Key;
import org.msh.tb.entities.enums.PatientType;

/**
 * Variable used in the monitoring & evaluation report to group values of patient type
 * Created by rmemoria on 5/6/17.
 */
public class PatientTypeReportVariable extends EnumFieldVariable {

    public PatientTypeReportVariable() {
        super("patient-type-rep",
                "manag.reportgen.var.pattyperep",
                "patientType",
                PatientType.class);
    }

    @Override
    public Key createKey(Object value, int iteration) {
        if (value != null) {
            int index = (Integer)value;
            PatientType pt = PatientType.values()[index];
            if (pt != PatientType.NEW && pt != PatientType.RELAPSE && pt != PatientType.UNKNOWN_PREVIOUS_TB_TREAT) {
                // return a value to indicate all other retreatments
                return Key.of(PatientType.CUSTOM1.ordinal());
            }
        }
        return super.createKey(value, iteration);
    }

    @Override
    public String getDisplayText(Key key) {
        Object val = key.getValue();
        if (val == null) {
            return super.getDisplayText(key);
        }

        if ((Integer)val == PatientType.CUSTOM1.ordinal()) {
            return "ALl other retreatment";
        }

        return super.getDisplayText(key);
    }
}
